﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.IO;

namespace Grupa_B
{
    public partial class Form1 : Form
    {
        double[,] podaci = new double[1800, 4];
        int pozicija = -1;
        double trenutnaBrzina = -1;

        public Form1()
        {
            InitializeComponent();
        }

        private void ucitajToolStripMenuItem_Click(object sender, EventArgs e)
        {
            try
            {
                StreamReader reader = new StreamReader("podaciB.txt");
                int trenutniRedak = 0;
                while (!reader.EndOfStream)
                {
                    string linija = reader.ReadLine();
                    string[] dijeloviLinije = linija.Split(';');

                    podaci[trenutniRedak, 0] = Convert.ToDouble(dijeloviLinije[0]);
                    podaci[trenutniRedak, 1] = Convert.ToDouble(dijeloviLinije[1]);
                    podaci[trenutniRedak, 2] = Convert.ToDouble(dijeloviLinije[2]);
                    podaci[trenutniRedak, 3] = Convert.ToDouble(dijeloviLinije[3]);

                    trenutniRedak++;
                }

                reader.Close();

                MessageBox.Show("Podaci su učitani!");
            }
            catch (Exception ex)
            {
                MessageBox.Show("Greška: " + ex.Message);
            }
        }

        private void btnZapocni_Click(object sender, EventArgs e)
        {
            int interval = Convert.ToInt32(txtIntervalSim.Text);
            pozicija = Convert.ToInt32(txtUnosPozicije.Text);
            timer1.Interval = interval;
            timer1.Enabled = true;
        }

        private void btnZavrsi_Click(object sender, EventArgs e)
        {
            timer1.Enabled = false;
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            if (pozicija < podaci.GetLength(0))
            {
                trenutnaBrzina = podaci[pozicija, 3];
                labTxtPozicija.Text = Convert.ToString(pozicija);
                labTxtBrzina.Text = trenutnaBrzina + " km/h";
                slika.Refresh();
            }
        }

        private void slika_Paint(object sender, PaintEventArgs e)
        {
            int radijus = 150;
            float x = (slika.Width / 2.0f) - (radijus / 2.0f);
            float y = (slika.Height / 2.0f) - (radijus / 2.0f);

            if (trenutnaBrzina >= 0 && trenutnaBrzina < 5)
            {
                e.Graphics.FillEllipse(Brushes.Red, x, y, radijus, radijus);
            }
            else if (trenutnaBrzina >= 5 && trenutnaBrzina < 25)
            {
                e.Graphics.FillEllipse(Brushes.Orange, x, y, radijus, radijus);
            }
            else if (trenutnaBrzina >= 25 && trenutnaBrzina < 55)
            {
                e.Graphics.FillEllipse(Brushes.Yellow, x, y, radijus, radijus);
            }
            else if (trenutnaBrzina >= 55 && trenutnaBrzina < 80)
            {
                e.Graphics.FillEllipse(Brushes.Green, x, y, radijus, radijus);
            }
            else if (trenutnaBrzina >= 80)
            {
                e.Graphics.FillEllipse(Brushes.Blue, x, y, radijus, radijus);
            }
            else
            {
                e.Graphics.FillEllipse(Brushes.Black, x, y, radijus, radijus);
            }

            pozicija++;
        }
    }
}